

data poissonbeddays;
input site $ target post days lives ohio alaska florida;
ln = log (lives);
cards;
ohio    0  0 43886  55120  1 0 0
ohio    0  1 38002  47751  1 0 0
ohio    1  0  9626  14947  1 0 0
ohio    1  1  8560  14110  1 0 0
florida 0  0 13857  23590  0 0 1
florida 0  1 13088  24063  0 0 1
florida 1  0  5742  13448  0 0 1
florida 1  1  4436  13718  0 0 1
alaska  0  0  5885  21173  0 1 0
alaska  0  1  5979  21760  0 1 0
alaska  1  0  3390  11500  0 1 0
alaska  1  1  3211  11820  0 1 0
;

libname q 'c:\sascodeforbook\SASDataSets';
Data ohio; set q.poissonbeddays;
	if ohio = 1; 
Title 'reduction in days for Ohio site O-2';
	proc genmod data =ohio; model days = target post target*post
        / dist = poisson  link = log offset=ln cl;
run;


Data florida; set q.poissonbeddays;
	if florida = 1; 
Title 'reduction in days for florida site O-3';
proc genmod; model days = target post target*post
        / dist = poisson    link = log   offset=ln cl;
run;

Data alaska; set q.poissonbeddays;
	if alaska = 1; 
Title 'reduction in days for alaska site O-4';
proc genmod; model days = target post target*post
        / dist = poisson    link = log   offset = ln cl;
run;

Data fixed; set q.poissonbeddays;
Title 'reduction in days controlling for site';
proc genmod; model days = target post target*post ohio alaska florida
        / dist = poisson    link = log   offset = ln cl;
run;



Title 'This code calculates the overall pooled effect';
data pooled; set q.poissonbeddays (drop = site ohio florida alaska ln);
proc sort data = pooled; by target post;
proc summary data = pooled nway missing;
        by target post;
        var days lives;
        output out = pooled1 sum=;
proc print data = pooled1;
run;
data pooled2; set pooled1;
ln = log (lives);
Title 'Poisson regression for pooled data';
proc genmod data=pooled2; model days = target post target*post
        / dist = poisson link = log offset = ln cl;
run;

Title 'This code calculates the overall pooled effect for cybernetic program';
data pooled; set q.poissonbeddays;
if site ne "ohio"; 
proc sort data = pooled; by target post;
proc summary data = pooled nway missing;
        by target post;
        var days lives;
        output out = pooled1 sum=;
proc print data = pooled1;
run;
data pooled2; set pooled1;
ln = log (lives);
Title 'Poisson regression for pooled data';
proc genmod data=pooled2; model days = target post target*post
        / dist = poisson link = log offset = ln cl;
run;


/* The syntax in this file is copyright by Robert B. Smith,  2011. */
